<?php
require_once(SITE_LOGICS . 'forgot/model.php');

class LogicForgot extends ForgotModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType()	== TYPE_SEND) {				// メールの送信
			$this -> select();

			// リロード制限がなければメール送信
			if($this -> insert()) {

				$this -> send();
			}
		} else if($this -> getType()	== TYPE_COMPLETE) {	// 完了
			$this -> update();

			// ステータスの変更
			$this -> status();

			$this -> del();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function update() {

		if($this -> accessModify('UPDATE_USER_PASSWORD', $this -> getUpdateParams())) {

			// メールの送信
			$this -> sendChangePasswordCommon($this -> getUserAccount());
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 情報の登録
	* @parameter	: UID，口座番号
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function insert() {

		// 変数宣言部
		$rtn	= true;
		$params = array();

		// データの一旦削除
		$rtn = $this -> removeApply();

		// 申請データの登録
		$this -> accessModify('INSERT_APPLY_PASSWORD', $this -> getInsertParams(), false);

		// ログインデータの登録
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータを取得する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function select() {

		// データを取得する
		$this -> setUser($this -> accessSelect('SELECT_USER_BY_ACCOUNT_OR_EMAIL', array($this -> getEmail())));

		// データの設定
		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請メールの送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {

		// 申請メールを送信する
		$this -> sendMailByTmp('change_password_apply.xml'
								, $this -> getSendParams()
								, $this -> getEmail()
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データの削除
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function removeApply() {
		return $this -> accessModify('DELETE_APPLY_PASSWORD', array($this -> fromEmailToUID($this -> getEmail())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データの削除
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function del() {
		$this -> accessModify('DELETE_APPLY_PASSWORD', $this -> getDeleteParams());
	}


	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザステータスの変更
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function status() {

		// 変数宣言部
		$account	= null;
		$row		= null;

		// データの取得
		$account = $this -> getAccountCommon($this -> getUserAccount());

		// データの存在確認
		if($this -> isLoopData($account)) {
			$row = $this -> getRowData($account);

			// 仮登録であれば、本登録へ変更
			if($this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_1) {
				$this -> accessModify('UPDATE_USER_STATUS', array($this -> getUserAccount(), VAL_INT_2), false);
			}
		}
	}
}
?>