<?php
require_once(SYSTEM_LOGICS . 'withdraw/model.php');

class LogicWithdraw extends WithdrawModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == TYPE_COMPLETE) {		// 出金データの登録
					$this -> regist();
					$this -> lists();

				} else if($this -> getType() == TYPE_INPUT) {	// 出金データの入力
					$this -> select();

				} else if($this -> getType() == TYPE_CONFIRM) {	// 出金データの確認
					$this -> select();

				} else if($this -> getType() == TYPE_DETAIL) {	// 出金データの詳細
					$this -> selectDetail();
					$this -> restore();

				} else if($this -> getType() == TYPE_SAVE) {	// 出金ステータスの更新
					$this -> save();
					$this -> selectDetail();
					$this -> restore();

				} else if($this -> getType() == TYPE_EXPORT) {	// エクスポート
					$this -> lists();
					$this -> makeFile();

				} else if($this -> getType() == TYPE_SEARCH) {	// 検索
					$this -> lists();

				} else {										// その他
					$this -> lists();
				}

				$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_WITHDRAW', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setUser($this -> accessSelect('SELECT_ACCOUNT', array($this -> setUserAccount())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function selectDetail() {
		$this -> setDetail($this -> accessSelect('SELECT_WITHDRAW', array($this -> getWId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金の登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_WITHDRAW', $this -> getRegistData());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function save() {
		$this -> accessModify('UPDATE_WITHDRAW_STATUS', $this -> getUpdateStatus());
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポート用のファイルを作成する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function makeFile() {

		// 変数宣言部
		$path			= NO_STRING;	// ファイルパス
		$fp 			= null;			// ファイルポインタ
		$rs 			= null;			// 結果セット
		$rowValues		= null;			// 表示データ
		$intermediary	= NO_STRING;	// 中継銀行

		// ファイルパス
		$path = SYSTEM_DOCUMENT_WITHDRAW . date('Ymd') . '.csv';

		// ファイルポインタの取得
		$fp = fopen($path, 'w+');

		// 結果セットの取得
		$rs = $this -> getResult();

		// タイトル行
		fputs($fp, '申請時間,アカウント名,金額,銀行口座,銀行名,SWIFT,中継銀行,ステータス' . "\n");

		// データの数だけループを回す
		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				if($row[COLUMN_INTERMEDIARY_FLG] == VAL_INT_1) {
					$intermediary = '利用する';
				} else {
					$intermediary = '利用しない';
				}

				// データストア
				$rowValues = array();
				$rowValues[] = $row[COLUMN_CREATE_TIME];
				$rowValues[] = $row[COLUMN_USER_NAME];
				$rowValues[] = $row[COLUMN_AMOUNT];
				$rowValues[] = $row[COLUMN_ACCOUNT_NUMBER];
				$rowValues[] = $row[COLUMN_RECEIPT_BANK_NAME];
				$rowValues[] = $row[COLUMN_RECEIPT_BANK_SWIFT];
				$rowValues[] = $intermediary;
				$rowValues[] = $this -> dispWithdrawStatusCommon($row[COLUMN_STATUS]);

				// ファイルの書き込み
				fputs($fp, implode(DELIMIT_COMMA, $rowValues) . "\n");
			}
		}

		fclose($fp);
	}


}
?>