<?php
require_once(SYSTEM_LOGICS . 'account_list/model.php');

class LogicAccountList extends AccountListModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			if($this -> getType()			== TYPE_EDIT) {			// データの詳細
				$this -> select();
			} else if($this -> getType()	== TYPE_UPLOAD) {		// データのインポート
				$this -> load();

			} else if($this -> getType()	== TYPE_COMPLETE) {		// データの登録

				$this -> regist();
			} else if($this -> getType() == TYPE_EXPORT) {			// エクスポート
				$this -> export();

			} else if($this -> getType() == TYPE_EXPORT_COMMON) {	// エクスポート(共通)
				$this -> listAll();
				$this -> export();

			} else {												// データの一覧
				$this -> lists();
			}
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {

		// 変数宣言部
		$rs		= null;
		$where	= null;

		// データの取得
		$where	= $this -> getWhere();
		//remove _REVISED if want to use old query - mark
		$rs		= $this -> accessSelect('LIST_ACCOUNTS_REVISED', $where);

		//remove _REVISED if want to use old query - mark
		$total	= intval($this -> getColumnData($this -> getRowData($this -> accessSelect('COUNT_ACCOUNTS_REVISED', $where)), COLUMN_COUNTER));

		// 合計数の設定
		$this -> setTotal($total);

		// データをモデルクラスへ設定
		$this -> setAccounts($rs);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 一覧の取得（検索結果全件取得）
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function listAll() {

		// 変数宣言部
		$rs		= null;
		$where	= null;

		// リミットなしに変更
		$where				= $this -> getWhere();
		$where[VAL_INT_2]	= NO_STRING;

		// データの取得
		$rs		= $this -> accessSelect('LIST_ACCOUNTS', $where);

		// データをモデルクラスへ設定
		$this -> setAccounts($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {

		// データの取得
		$this -> setUserDetail($this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($this -> getDetailAccount())));

		// データの再設定
		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードファイルのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function load() {

		// 変数宣言部
		$id		= NO_STRING;
		$list	= NO_STRING;

		// ファイルのロード
		$tmpFile = fopen($_FILES[PARAM_CSV][PARAM_TMP_NAME], 'r');

		// CSV配列へ変換
		while ($csv[] = fgetcsv($tmpFile, VAL_INT_1024)) {}

		// タイトル行の削除
		array_shift($csv);

		// 表示用にデータ設定
		$this -> setCSV($csv);

		// 表示データの作成
		$this -> makeData();

		// データの一時登録
		$id = $this -> getID();
		$list = $this -> getFailList();

		// エラーリストにデータがあれば、登録する
		if($this -> isLoopData($list)) {

			// ファイルの作成
			$path = SYSTEM_DOCUMENT_ACCOUNT . $id . '_fail.csv';
			touch($path);
			chmod($path, 0777);
			$pointer = fopen($path, 'w');

			foreach($list as $row) {
				fwrite($pointer, implode(DELIMIT_COMMA, $row) . "\n");
			}

			fclose($pointer);
		}

		// インポートリストにデータがあれば、登録する
		$list = $this -> getTrueList();
		if($this -> isLoopData($list)) {

			// ファイルの作成
			$path = SYSTEM_DOCUMENT_ACCOUNT . $id . '_true.csv';
			touch($path);
			chmod($path, 0777);
			$pointer = fopen($path, 'w');

			foreach($list as $row) {

				// ファイルの書き込み
				fwrite($pointer, implode(DELIMIT_COMMA, $row) . "\n");
			}

			fclose($pointer);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 変数宣言部
		$csv	= array();
		$path	= SYSTEM_DOCUMENT_ACCOUNT . $this -> getID() . '_true.csv';

		// ファイルの存在確認
		if(!file_exists($path)) {
			return;
		}

		// ファイルのロード
		$tmpFile = fopen(SYSTEM_DOCUMENT_ACCOUNT . $this -> getID() . '_true.csv', 'r');

		// CSV配列へ変換
		while ($csv[] = fgetcsv($tmpFile, VAL_INT_1024)) {}

		if($this -> isLoopData($csv)) {

			foreach($csv as $row) {

				// 配列でなければ、無視
				if(count($row) < VAR_REGIST_CSV_COUNT) {
					continue;
				}

				// パラメータの設定
				$uid		= $this -> createUId();
				$account	= $this -> createAccount();
				$confCode	= $this -> createConfirmCode();
				$aType		= NO_COUNT;

				$params		= array();
				$params[]	= $uid;										// UID
				$params[]	= $this -> getColumnData($row, VAL_INT_1);	// ログインID
				$params[]	= $this -> createAgentCode();				// ログインパスワード

				// ログインデータの登録
				$rtn = $this -> accessModify('INSERT_LOGIN', $params);

				// データが正常更新されなければ返却
				if(!$rtn) {
					return $rtn;
				}

				// 口座種別の設定
				if($this -> getColumnData($row, NO_COUNT) != 'personal') {
					$aType = VAL_INT_1;
				}

				// 生年月日の分割
				$birth = explode(DELIMIT_SLASH, $this -> getColumnData($row, VAL_INT_5));

				// 国の逆引き
				$cCode = $this -> getCountryCodeFromCountryName($this -> getColumnData($row, VAL_INT_2));

				$params		= array();
				$params[]	= $uid;													// UID(0)
				$params[] 	= $this -> getColumnData($row, VAL_INT_1);				// メルアド(1)
				$params[] 	= $aType;												// 口座種別(2)
				$params[] 	= $account;												// 口座番号(3)
				$params[] 	= $this -> getColumnData($row, VAL_INT_11);				// 電話番号(4)
				$params[] 	= $this -> getColumnData($row, VAL_INT_4);				// 姓(5)
				$params[] 	= $this -> getColumnData($row, VAL_INT_3);				// 名(6)
				$params[] 	= intval($this -> getColumnData($birth, NO_COUNT));		// 生年月日（年）(7)
				$params[] 	= intval($this -> getColumnData($birth, VAL_INT_1));	// 生年月日（月）(8)
				$params[] 	= intval($this -> getColumnData($birth, VAL_INT_2));	// 生年月日（日）(9)
				$params[] 	= $cCode;												// 国(10)
				$params[] 	= $this -> getColumnData($row, VAL_INT_7);				// 都道府県(11)
				$params[] 	= $this -> getColumnData($row, VAL_INT_8);				// 市(12)
				$params[] 	= $this -> getColumnData($row, VAL_INT_10);				// 郵便番号(13)
				$params[] 	= $this -> getColumnData($row, VAL_INT_9);				// 番地(14)
				$params[] 	= NO_STRING;											// 番地2(15)
				$params[] 	= NO_STRING;											// エージェントコード(16)
				$params[] 	= NO_COUNT;												// エージェントフラグ(17)
				$params[] 	= $this -> getColumnData($row, VAL_INT_6);				// 親エージェントコード(18)
				$params[] 	= $this -> getAdminUserData(PARAM_USER_ACCOUNT);		// 親エージェントコード(19)
				$params[] 	= VAL_INT_1;											// ステータス（仮登録(20)
				$params[] 	= NO_STRING;											// CRM ID(21)
				$params[]	= $this -> getColumnData($row, VAL_INT_13);				// ホワイトレーベルID(22)
				$params[] 	= VAR_DEFAULT_LANGAGE;									// 言語(23)
				$params[] 	= NO_STRING;											// ダミー(24)
				$params[] 	= NO_STRING;											// ダミー(25)
				$params[] 	= NO_STRING;											// ダミー(26)

				// ユーザ情報登録の前にCRM IDを取得する
				$crmId		= $this -> crmInsertRecordsRegistCSV($params);
				$params[VAL_INT_21]	= $crmId;

				$rtn		= $this -> accessModify('INSERT_USER', $params, false);
				$this -> accessModify('INSERT_2FA_ENABLE', array($account), false);
				$this -> accessModify('INSERT_2FA_CODE', array($account), false);
				
				// データのコメントを更新する
				$this -> accessModify('UPDATE_USER_NOTE', array($account, $this -> getColumnData($row, VAL_INT_12)), false);

				$params		= array();
				$params[]	= $uid;			// UID
				$params[]	= $account;		// 口座番号
				$params[]	= $confCode;	// 確認コード

				// パスワード変更申請
				// データの一旦削除
				$this -> accessModify('DELETE_APPLY_PASSWORD', array($uid));

				// 申請データの登録
				$this -> accessModify('INSERT_APPLY_PASSWORD', $params);

				// 申請メールを送信する
				$params		= array();
				$params[]	= $account;														// 口座番号
				$params[]	= $this -> getColumnData($row, VAL_INT_3)
								. DELIMIT_SPACE . $this -> getColumnData($row, VAL_INT_4);	// 名前
				$params[]	= $uid;															// UID
				$params[]	= $confCode;													// 確認コード

				$this -> sendMailByTmpAndWL($account
											, 'regist_password_apply.xml'
											, $params
											, $this -> getColumnData($row, VAL_INT_1)
											, 'cs@');
			}
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: 失敗ファイルのエクスポート
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function export() {

		// データの作成
		$this -> makeExportData();
	}
}
?>
