<?php
class SummaryModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $balances	= null;
	private $currencies	= null;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のバランスデータの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの設定
	* @parameter	: 通貨データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 決済セットの設定（口座一覧）
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function dispList() {


		// 変数宣言部
		$lists	= array();
		$rtn	= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {

			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {

			// データの数だけループを回す
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = number_format($this -> intToCurrency(NO_COUNT, $currency), $this -> getDigitCount($currency));
				} else {
					$amount = number_format($this -> intToCurrency($this -> getColumnData($data, COLUMN_BALANCE), $currency), $this -> getDigitCount($currency));
				}

				$rtn	.= '<tr>'
						. '<td><a href="history.php?currency=' . $currency . '">' . $currency . '</a></td>'
						. '<td class="ralign">' . $amount . '</td>'
						. '</tr>';
			}

		}

		echo $rtn;
	}
}
?>