<?php
require_once(SITE_LOGICS . 'card_apply/model.php');

class LogicCardApply extends CardApplyModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == TYPE_COMPLETE) {		// 完了
			$this -> regist();

		} else {										// その他
			$this -> lists();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {

		// 変数宣言部
		$rs = $this -> accessSelect('LIST_CARD_APPLY_USER', array($this -> getUserData(PARAM_USER_ACCOUNT)));

		$this -> setResult($rs);

		if(count($rs) >= VAL_INT_2) {	// カードが規定以上ある場合（とりあえず、2枚）
			$this -> setType(TYPE_FAIL);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {

		// 取得枚数分登録する
		for($cnt = NO_COUNT; $cnt < $this -> getIndex(); $cnt++) {

			if($cnt == NO_COUNT) {
				if(!$this -> accessModify('INSERT_USER_CARD_APPLY', $this -> getRegistData())) {
					return false;
				}
			} else {
				$this -> accessModify('INSERT_USER_CARD_APPLY', $this -> getRegistData(), false);
			}
		}

		// メールの送信
		$this -> popUpSessionMessage(INFO, 'I_CARD_APPLY_COMPLETE', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>