
<?php
require_once('config.php');

class APIMakeRequestStatusCancel extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= 	NO_STRING;
	private $account		= NO_STRING;
	private $fee			= NO_STRING;
	private $fee2			= NO_STRING;
	private $rId			= NO_STRING;	// 引落ID
	private $status			= NO_STRING;	// ステータス
	private $sendMessage	= NO_STRING;	// メッセージ（返信メッセージ）
	private $fromCurrency	= NO_STRING;	// From通貨



	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;
		$row		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> rId			= $this -> getDataPost(PARAM_R_ID);			// 引落ID
			$this -> status			= $this -> getDataPost(PARAM_STATUS);		// ステータス
			$this -> sendMessage	= $this -> getDataPost(PARAM_SEND_MESSAGE);	// メッセージ（返信メッセージ）

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'R' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// データの更新
			$param		= array();
			$param[] 	= $this -> rId;
			$param[] 	= $this -> status;
			$param[] 	= addslashes($this -> sendMessage);

			$this -> accessModify('UPDATE_REQUEST_ROLL_BACK', $param);

			// メール送信
			$row = $this -> getRowData($this -> getRequestCommon($this -> rId));

			$param		= array();
			$param[]	= $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
			$param[] 	= $this -> getNameCommon($this -> account);
			$param[] 	= $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
			$param[] 	= $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING);
			$param[] 	= $this -> getColumnData($row, COLUMN_CURRENCY);
			$param[] 	= $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
			$param[] 	= $this -> getColumnData($row, COLUMN_MESSAGE);
			$param[] 	= $this -> getCurrentTimeCommon();
			$param[] 	= addslashes($this -> sendMessage);
			$param[] 	= $this -> getColumnData($row, COLUMN_TO_MAIL);

			$this -> sendMailByTmp('request_roll_back.xml'
									, $param
									, $param[VAL_INT_9]
									, VAR_CS_MAIL_ADDRESS);

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 口座の存在確認
		$this -> user = $this -> getAccountCommon($this -> account);

		if(count($this -> user) == NO_COUNT) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 必須項目
		// debit口座のチェック
// 		if(!$this -> checkNull($this -> fromCurrency)) {
// 			throw new Exception('E_REQUIRED_VALUE');
// 		}

// 		// 残高のチェック
// 		$balance			= $this -> getBalanceCommon($this -> account, $this -> fromCurrency);
// 		$row				= $this -> getRowData($this -> getRequestCommon($this -> rId));

// 		$this -> currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
// 		$amount				= $this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> currency);
// 		$fee				= $this -> getFeeCommon(VAR_TRANSFER
// 													, $amount
// 													, $this -> currency
// 													, $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)
// 													, $this -> getColumnData($row, COLUMN_TO_ACCOUNT));

// 		// バランスと（送金額 + 手数料）のチェック

// 		// 引き落し額
// 		$exchange		= $this -> getExchangeCommon($amount, $this -> currency, $this -> fromCurrency, false, true);
// 		$this -> amount	= $exchange[PARAM_AMOUNT];

// 		// 引き落し手数料
// 		$exchange		= $this -> getExchangeCommon($fee[$this -> currency . VAL_INT_1], $this -> currency, $this -> fromCurrency);

// 		$this -> fee	= $exchange[PARAM_AMOUNT];

// 		// レート
// 		$this -> rate	= $exchange[PARAM_RATE];

// 		// 受け取り手数料
// 		$this -> fee2	= $fee[$this -> currency . VAL_INT_2];
// 		$total			= $this -> amount + $this -> fee;
// 		$this -> agent1	= $fee[PARAM_AGENT_CODE . VAL_INT_1];
// 		$this -> agent2	= $fee[PARAM_AGENT_CODE . VAL_INT_2];


// 		if($balance < $total) {
// 			throw new Exception('E_INSUFFICIENT_FUNDS');
// 		}

// 		// 制限口座のチェック
// 		if(!$this -> checkWithdrawLimit($this -> account, $this -> getColumnData($row, COLUMN_CURRENCY), $this -> getColumnData($row, COLUMN_AMOUNT))) {
// 			throw new Exception('E_LIMIT_WITHDRAW');
// 		}
	}
}

$api = new APIMakeRequestStatusCancel();
$api -> action();
?>