﻿<?php
class KYCModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $targetCountry			= NO_STRING;
	private $mail 					= NO_STRING;
	private $name 					= NO_STRING;
	private $accountNumber  		= NO_STRING;
	private $accountType 			= NO_STRING;
	private $agentCode 				= NO_STRING;
	private $status 				= NO_STRING;
	private $comment				= NO_STRING;
	private $sFrom 					= NO_STRING;
	private $sTo 					= NO_STRING;
	private $sStatusFrom 			= NO_STRING;
	private $sStatusTo 				= NO_STRING;
	private $openFlg				= NO_STRING;	// 開設日検索フラグ
	private $loginFlg				= NO_STRING;	// ログイン日検索フラグ
	private $updateStatus 			= NO_STRING;
	private $currentStatus 			= NO_COUNT;
	private $arrStatus				= array();
	private $arrSelectAll 	 		= array();
	private $arrValidate	  		= array();

	/**
	 *
	 * anton
	 *
	 */
	private $lang			= NO_STRING;
	private $count          = NO_COUNT;


	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {
		/*var_dump(234566);
		exit();*/
		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> userAccount	= $this -> getDataPost(PARAM_USER_ACCOUNT, true);	// ユーザ口座番号
		$this -> arrStatus		= $this -> getDataPost(PARAM_STATUSES, true);
		$this -> mail 			= $this -> getDataPost(PARAM_EMAIL, true);
		$this -> targetCountry	= $this -> getDataPost(PARAM_COUNTRY, true);
		$this -> name 			= $this -> getDataPost(PARAM_NAME, true);
		$this -> accountNumber	= $this -> getDataPost(PARAM_USER_ACCOUNT, true);
		$this -> accountType 	= $this -> getDataPost(PARAM_ACCOUNT_TYPE, true);
		$this -> agentCode		= $this -> getDataPost(PARAM_AGENT_CODE, true);
		$this -> account_status	= $this -> getDataPost(PARAM_ACCOUNT_STATUS, true);
		$this -> comments		= $this -> getDataPost(PARAM_COMMENT, true);
		$this -> openFlg		= $this -> getDataPost(PARAM_OPEN_FLG, true);
		$this -> sFrom 			= $this -> getDataPost(PARAM_FROM, true);
		$this -> sTo 			= $this -> getDataPost(PARAM_TO, true);
		$this -> loginFlg 		= $this -> getDataPost(PARAM_LOGIN_FLG, true);
		$this -> sStatusFrom	= $this -> getDataPost(PARAM_S_FROM, true);
		$this -> sStatusTo 		= $this -> getDataPost(PARAM_S_TO, true);
		$this -> arrSelectAll 	= $this -> getDataPost(PARAM_SELECT_ALL, true);
		$this -> updateStatus 	= $this -> getDataPost(PARAM_UPDATE_STATUS, true);
		$this -> KYC_Comment    = $this -> getDataPost(PARAM_KYC_COMMENT, true);
		/*$this -> kId			= $this -> getDataPost(PARAM_K_ID);			// KYCID
		$this -> statusArr		= $this -> getDataPost(PARAM_STATUS);		// ステータス*/

		$this -> setValidateParaments();
		// ユーザ一覧からのリンク対応
		if($this -> userAccount == NO_STRING) {
			$this -> userAccount = $this -> getDataGet(PARAM_USER_ACCOUNT, true, true, true);
		}

		$this -> lang			= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		/*var_dump(12345);
		exit();*/
		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('KYCC', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_UPDATE_ALL) {
			//check access
			if(!$this -> checkAdminUserAccess('KYCC', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('KYDT', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('KYDT', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE_IMAGE) {
			//check access
			if(!$this -> checkAdminUserAccess('IDDS', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE_IMAGE) {
			//check access
			if(!$this -> checkAdminUserAccess('IDDS', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_VERTIFY) {
			//check access
			if(!$this -> checkAdminUserAccess('VUSR', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		return true;
	}


	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> count)
				, $this -> count
				, NO_STRING
				, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 回数の設定
	 * @parameter	: 回数
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setCount($count){
	    $this -> count = $count;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: 結果セット
	* @return		: 検索条件配列
	-------------------------------------------------------------------------*/
	function getWhere($applyLimit = false) {

		// 変数宣言部
		$where		= NO_STRING;
		$having		= NO_STRING;
		$rtn		= array();
		$statuses	= array();

		// メールアドレス
		if($this -> mail != NO_STRING) {
			$where .= ' AND users.mail LIKE (\')%' . $this -> mail . '%(\')';
		}

		// 氏名
		if($this -> name != NO_STRING) {
			$where .= ' AND (users.last_name LIKE (\')%' . $this -> name . '%(\') OR users.first_name LIKE (\')%' . $this -> name . '%(\'))';
		}

		// 口座番号
		if($this -> accountNumber != NO_STRING) {
			$where .= ' AND users.user_account = (\')' . $this -> accountNumber . '(\')';
		}

		// 国
		if($this -> targetCountry != NO_STRING) {
			$where .= ' AND users.country = (\')' . $this -> targetCountry . '(\')';
		}

		// エージェントコード
		if($this -> agentCode != NO_STRING) {
			$where .= ' AND users.agent_code = (\')' . $this -> agentCode . '(\')';
		}

		// 状態
		if($this -> account_status != NO_STRING) {
			$where .= ' AND users.status = (\')' . $this -> account_status . '(\')';
		}

		// 口座種別
		if($this -> accountType != NO_STRING) {
			$where .= ' AND users.account_type = (\')' . $this -> accountType . '(\')';
		}

		// 検索のフラグがある場合
		if($this -> openFlg != NO_STRING) {
			// 開始日（口座開設日）
			if($this -> sFrom != NO_STRING) {
				$having .= ' AND kyc.create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sFrom) . '(\')';
			}

			// 終了日（口座開設日）
			if($this -> sTo != NO_STRING) {
				$having .= ' AND kyc.create_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// 検索のフラグがある場合
		if($this -> loginFlg != NO_STRING) {

			// 開始日（最終ログイン日）
			if($this -> sStatusFrom != '2014/01/01'
					&& $this -> sStatusFrom != NO_STRING) {
				$having .= ' AND users.process_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sStatusFrom) . '(\')';
			}

			// 終了日（最終ログイン日）
			if($this -> sStatusTo != NO_STRING) {
				$having .= ' AND users.process_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sStatusTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// comments
		if($this -> comments != NO_STRING) {
			$where .= ' AND (users.kyc_comment LIKE (\')%' . $this -> comments . '%(\'))';
		}

		if(!empty($this -> arrStatus)){

			$where .= ' AND (';

			foreach($this -> arrStatus as $row) {
				$statuses[] = ' users.kyc_validate_status = (\')' . $row . '(\')';
			}

			$where .= implode(DELIMIT_OR, $statuses) . ')';
		}
		$where .= ' '.$having;
		$rtn[] = $where;
		
		if($applyLimit){
		    $start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		    $rtn[] = " LIMIT {$start}, ".VAL_INT_50;
		}
		
		return $rtn;
	}

	// 批量更新状态参数获取方法
	function getConidition(){
		$rtn		= array();
		$statuses	= array();
		$updates 	= NO_STRING;
		$where 		= NO_STRING;

		if($this -> updateStatus != NO_STRING){
			$updates = $this -> updateStatus;
		}

		if(!empty($this -> arrSelectAll)){
			$where .= '  (';
			foreach($this -> arrSelectAll as $row) {
				$statuses[] = ' user_account = (\')' . $row . '(\')';
			}
			$where .= implode(DELIMIT_OR, $statuses) . ')';
		}else{
			echo '<script>alert("'.VAL_KYC_SELECT_TARGET.'");</script>';
			return False;
		}

		$rtn[] = $updates;
		$rtn[] = $where;
		$rtn[] = date("Y-m-d H:i:s");
		return $rtn;
	}

	// 更新用户Comments与状态
	function getDetailCondition(){
		$rtn		= array();

		if($this -> updateStatus != NO_STRING){
			$rtn[] = $this -> updateStatus;
		}

		if($this -> KYC_Comment != NO_STRING){
			$rtn[] = $this -> KYC_Comment;
		}else{
			$rtn[] = '';
		}

		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $this -> userAccount;
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ（ユーザのKYCフラグ更新）を取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function updateKYCFlg() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;
		$rtn[] = VAR_FLG_ON;

		return $rtn;
	}

	function getUpdateStatusParams($arr){
		$rtn		= array();
		$rtn[] = $arr[VAL_INT_1];
		$rtn[] = $arr[NO_COUNT];
		return $rtn;
	}

	public function setValidateParaments(){

		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_1;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_2;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_3;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_4;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_5;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_6;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_7;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_8;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_9;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_10;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_11;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_12;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_13;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_14;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_15;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_16;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_17;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_18;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_19;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_20;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_21;

	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {
			// データの数だけループを回す			
			foreach($this -> rs as $row){
			    $rtn	.= '<tr>'
			         . '<td>' . $this -> dispCountryCommon($this -> getColumnData($row , COLUMN_COUNTRY)) . '</td>'
			         . '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_NAME) .'</a></td>'
			         . '<td class="l">' . $this -> getNameCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT)) . '</td>'
			         . '<td>' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT)  . '</td>'
			         . '<td class="r">' . $this -> dispUserAccountTypeCommon($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE))  .'</td>'
			         . '<td class="r">' . $this -> getColumnData($row, COLUMN_MAX_CREATE_TIME) . '</td>'
			         . '<td>' . $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_USER_STATUS)) . '</td>'
			         . '<td>' . $this -> arrValidate[$this -> getColumnData($row, COLUMN_VALIDATE_STATUS)] . '</td>'
			         . '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_TIME) . '</td>'
			         . '<td><a href="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
			         . '<td><input name="selectAll[]" value="'.$this -> getColumnData($row, COLUMN_USER_ACCOUNT).'" type="checkbox"></td>'
			         . '</tr>';
			}
		} else 
			$rtn = '<tr><td colspan="11">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';

		echo $rtn;
	}

	function getDetail(){
		// 変数宣言部
		$rtn	= NO_STRING;

		$this -> currentStatus = $this -> getColumnData($this -> rs[0], COLUMN_VALIDATE_STATUS);
		$rtn 	.= '<tr>'
					. '	<th>'.VAL_KYC_ADMIN_WL.'</th>'
					. '	<td>'.VAL_STR_USER_WL.'</td>'
                    . ' <th>'.VAL_STR_COUNTRY.'</th>'
					. '	<td>'.$this -> dispCountryCommon($this -> getColumnData($this -> rs[0], COLUMN_COUNTRY)).'</td>'
                    . ' <th>'.VAL_STR_NOTE.'</th>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_STR_ADMIN_UNAME.'</th>'
					// . '	<td><a href="javascript:userDetail(\''.$this -> getColumnData($this -> rs[0], COLUMN_USER_ACCOUNT).'\',\'_blank\');">'.$this -> getColumnData($this -> rs[0], COLUMN_USER_NAME).'</a></td>'
					. '	<td><a href="account_edit?detail_account=' . $this -> getColumnData($this -> rs[0], COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($this -> rs[0], COLUMN_USER_NAME) .'</a></td>'
                    . ' <th>'.VAL_STR_STATE.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_STATE).'</td>'
                    . ' <td rowspan="7">'.$this -> getColumnData($this -> rs[0], COLUMN_NOTE).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_STR_USER_ACCOUNT.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_USER_ACCOUNT).'</td>'
                    . ' <th>'.VAL_KYC_ADMIN_MUNICIPALITY.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_CITY).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_STR_ADMIN_NAME.'</th>'
					. '	<td>'.$this -> getNameCommon($this -> getColumnData($this -> rs[0], COLUMN_USER_ACCOUNT)).'</td>'
                    . ' <th>'.VAL_KYC_ADMIN_STRADDRESS.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_ADDRESS).' '.$this -> getColumnData($this -> rs[0], COLUMN_ADDRESS_2).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_KYC_ADMIN_BIRTHDATE.'</th>'
					. '	<td>'.date("Y-m-d",strtotime($this -> getColumnData($this -> rs[0], COLUMN_BIRTH))).'</td>'
                    . ' <th>'.VAL_STR_ZIP_CODE.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_ZIP_CODE).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_STR_STATUS.'</th>'
					. '	<td>'.$this -> dispUserStatusCommon($this -> getColumnData($this -> rs[0], COLUMN_USER_STATUS)).'</td>'
                    . ' <th>'.VAL_KYC_ADMIN_PNUMBER.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_TEL).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>'.VAL_STR_ACCOUNT_TYPE.'</th>'
					. '	<td>'.$this -> dispUserAccountTypeCommon($this -> getColumnData($this -> rs[0], COLUMN_ACCOUNT_TYPE)).'</td>'
                    . ' <th>'.VAL_KYC_ADMIN_AGENT.'</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_AGENT_CODE).'</td>'
					. '</tr>'
                    . '<tr>'
					. '	<th>CRM ID</th>'
					. '	<td>'.$this -> getColumnData($this -> rs[0], COLUMN_CRM_ID).'</td>'
                    . ' <th>'.VAL_STR_CORP_REP_NAME.'</th>'
					. '	<td>' . $this -> getColumnData($this -> rs[0], COLUMN_CEO_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($this -> rs[0], COLUMN_CEO_LAST_NAME) . '</td>'
					. '</tr>';

		return $rtn;
	}

	function getKYCDetailComments(){
		$rtn = $this -> getColumnData($this -> rs[0], COLUMN_COMMENT);
		return $rtn;
	}

	function echoImageList(){
		// 変数宣言部
		$rtn		= NO_STRING;
		$base		= NO_COUNT;
		$rCnt		= NO_COUNT;
		$kycStatus	= array();
		$kycList	= array();
		$domain		= NO_STRING;

		// 編集した

		// 行数を取得
		$base = ceil(count($this -> rs) / 5);
		// KYCステータスのリストの取得
		$kycList = $this -> getKYCFlgList();
		for ($c = 1; $c <= $base; $c++) {
			$rtn .= '<tr>';
			for ($i = 0; $i <= 4; $i++) {

				$row	= $this -> getRowData($this -> rs, $rCnt + $i);
				$title	= $this -> getValueByList($this -> getIdentityTypeList(), $this-> getColumnData($row, COLUMN_FILE_TYPE));

				if($title != NO_STRING) {
					$rtn .= '<th class="w16p">' . $title . '</th>';
				} else {
					$rtn .= '<th class="w16p">' .VAL_KYC_ADMIN_UTYPE. '</th>';
				}
			}

			$rtn .= '</tr>'
					. '<tr>';

			for ($i = 0; $i <= 4; $i++) {
				if(isset($this -> rs[$rCnt + $i][COLUMN_FILE_TYPE])) {
				    
					$row	= $this -> getRowData($this -> rs, $rCnt + $i);
					$key	= $this -> getColumnData($row, COLUMN_K_ID) . DELIMIT_UNDER_BAR;

					// Key値の変更
					$kycStatus = array();
					if($this -> isLoopData($kycList)) {
						foreach($kycList as $data) {
							$data[PARAM_DATA_KEY] = $key . $data[PARAM_DATA_KEY];
							$kycStatus[] = $data;
						}
					}

					if($this -> getColumnData($this -> rs[$rCnt + $i], COLUMN_WL_ID) == VAL_INT_1) {
						$domain = 'https://' . WHITE_LABEL_SYSTEM_DOMAIN_1;
					} else {
						$domain = NO_STRING;
					}

					$filetype = $this -> getFileType($this -> rs[$rCnt + $i][COLUMN_SAVE_FILENAME]);					
					
					$keyPrefix = "kyc/".substr($this->userAccount, strlen($this->userAccount) - 3)."/{$this->userAccount}";
					
					$bucketKyc = AWSMangos3Bucket::getInstance()
					   ->getPresignedBucketFile("{$keyPrefix}/{$this->rs[$rCnt + $i][COLUMN_SAVE_FILENAME]}");
					
					if($filetype == 'pdf'){
						$rtn	.= '<td>'
							.'<div class="kyc_img"><a href="' . $bucketKyc . '" target="_blank">' . $this -> rs[$rCnt + $i][COLUMN_OLD_FILENAME] . '</a></div>'
							.'<input type="checkbox" class="cb-left" name="download[]" value="'.substr($key, 0,-1).'">Uploaded: ' . $this -> rs[$rCnt + $i][COLUMN_CREATE_TIME] . '<br>'.VAL_KYC_ADMIN_FILENAME.': ' . $this -> getColumnData($row, COLUMN_OLD_FILENAME)
							. '</td>';
					}else{
						$rtn	.= '<td>'
						    .'<div class="kyc_img"> <img data-original="' . $bucketKyc . '" src="' . $bucketKyc . '" width="65%;"></div>'
							.'<input type="checkbox" class="cb-left" name="download[]" value="'.substr($key, 0,-1).'">Uploaded: ' . $this -> rs[$rCnt + $i][COLUMN_CREATE_TIME] . '<br>'.VAL_KYC_ADMIN_FILENAME.': ' . $this -> getColumnData($row, COLUMN_OLD_FILENAME)
							. '</td>';
					}


				} else {
					$rtn .= '<td></td>';
				}
			}
			$rtn .= '</tr>'
					. '<tr>';
			for ($i = 0; $i <= 4; $i++) {
				$row	= $this -> getRowData($this -> rs, $rCnt + $i);
				$key	= $this -> getColumnData($row, COLUMN_K_ID) . DELIMIT_UNDER_BAR;

				// Key値の変更
				$kycStatus = array();
				if($this -> isLoopData($kycList)) {
					foreach($kycList as $data) {
						$data[PARAM_DATA_KEY] = $key . $data[PARAM_DATA_KEY];
						$kycStatus[] = $data;
					}
				}
				$rtn .= '<td>'
					 .' <select name="status[]" class="w100p">'
	                 .  $this -> dispListOption($kycStatus, $key . $this -> getColumnData($row, COLUMN_STATUS))
                   	 .'	</select>'
                   	 .'</td>';
			}

			$rtn .= '</tr>';
			$rCnt = $rCnt + 5;
		}

		echo $rtn;
	}

	function updateImagesStatus($idStr){
		// 変数宣言部
		$arr	= null;
		// まずはパラメータを分割
		$arr = explode(DELIMIT_UNDER_BAR, $idStr);

		if($arr[NO_COUNT] == NO_STRING){
			return;
		}else{
			$this -> accessModifyCommon('UPDATE_KYC_ADMIN_IMAGE_STATUS',$this -> getUpdateStatusParams($arr));
			return $arr[VAL_INT_1];
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ（ユーザのフラグ更新）を取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	function deleteImage($idStr){
		// 変数宣言部
		$arr	= null;
		// まずはパラメータを分割
		$arr = explode(DELIMIT_UNDER_BAR, $idStr);

		if($arr[NO_COUNT] == NO_STRING){
			return;
		}else if($arr[VAL_INT_1] == VAL_INT_2){
			//查询记录
			$this -> setResult($this -> accessSelect('SELECT_KYC_BY_K_ID', array($arr[0])));
			
			if($this -> isLoopData($this -> rs)) {
				foreach ($this -> rs  as $row) {
					$saveFilename = $this -> getColumnData($row, COLUMN_SAVE_FILENAME);
				}
				
				//删除存在文件
				$keyPrefix = "kyc/".substr($this->userAccount, strlen($this->userAccount) - 3)."/{$this->userAccount}";
				
				AWSMangos3Bucket::getInstance()->deleteFile("{$keyPrefix}/{$saveFilename}");
			}
			
			$this -> accessModifyCommon('DELETE_KYC_ADMIN_IMAGE_RECORDS', array($arr[0]));
			
			return 1;
		}

		if($arr[NO_COUNT] != NO_STRING && $arr[VAL_INT_1] != 2){
			//当值不为2时更新记录
			$this -> accessModifyCommon('UPDATE_KYC_ADMIN_IMAGE_STATUS',$this -> getUpdateStatusParams($arr));
			return $arr[VAL_INT_1];
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ（ユーザのフラグ更新）を取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function updateUserFlg() {
		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;
		$rtn[] = VAL_INT_3;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ口座番号の取得
	* @parameter	: なし
	* @return		: ユーザ口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> userAccount;
	}

	public function getCountryList(){
		$arrTmp = $this -> getCountyList();
		unset($arrTmp[0]);
		return $this -> dispListOption($arrTmp, $this -> targetCountry);
	}

	public function getCheckValidateList(){
		$str = '';
		
		foreach($this -> arrValidate as $key=>$val){
			$str .= '<label>';
			$checked =  '';
			$checked = VAL_INT_99;
			
			if(!empty($this -> arrStatus)){
				foreach($this -> arrStatus as $v){
					if($key == $v){
						$checked = $v;
						break;
					}
				}
			}

			$str .= $this -> makeCheckOne('statuses'.$key,
				'statuses[]',
				$key,
				$val,
				$checked);
			$str .= '</label>'."\r\n";
		}
		return $str;
	}

	public function getSelectValidateList(){
		$arrTmp = array();
		foreach($this -> arrValidate as $key=>$val){
			$arrTmp[$key][PARAM_DATA_KEY] = $key;
			$arrTmp[$key][PARAM_DATA_VALUE] = $val;
		}
		return $this -> dispListOption($arrTmp,$this -> currentStatus);
	}

	function getFileType($filename) {
		return substr($filename, strrpos($filename, '.') + 1);
	}

	public function downloadImage(){
	    ob_start();
	    
		//整理要下载的图片的信息，名称，路径等信息
		$date = date("YmdHis");

		$this -> downArr = $this -> getDataPost(TYPE_DOWNLOAD);
		if(empty($this -> downArr)){
			echo '<script>alert("'.VAL_KYC_ADMIN_DLIMAGEMES.'");</script>';
			return;
		}
		
		$path = $this -> getKycDirectoryWeb($this -> userAccount);
		
		$temp = SYSTEM_PATH.$path;
				
		mkdir($temp, 0777, true);
		
		$arrTmp = array();
		
		if($this -> isLoopData($this -> rs)){
			foreach($this -> rs as $row){
				if(in_array($row['k_id'],$this -> downArr)){
				    $keyPrefix = "kyc/".substr($this->userAccount, strlen($this->userAccount) - 3)."/{$this->userAccount}";
				    
				    $kycContent = file_get_contents(AWSMangos3Bucket::getInstance()->getPresignedBucketFile("{$keyPrefix}/{$row['save_filename']}"));
				    
				    if($kycContent){
				        file_put_contents($temp.DIRECTORY_SEPARATOR.$row['save_filename'], $kycContent);
				        
				        $arrTmp[$row['k_id']] = $path.DIRECTORY_SEPARATOR.$row['save_filename'];
				    }
				}
			}
		}

		//打包zip
		$zip 				= new ZipArchive();
		$downloadFilename 	= $date.'_'.$this -> userAccount.'.zip';
		$apiPath 			= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';

		$result = $zip->open($apiPath.DIRECTORY_SEPARATOR.$downloadFilename, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE);
		
		if ($result !== true) {
		    return false;
		}
		//処理制限時間を外す
		// set_time_limit(0);
		foreach($arrTmp as $val){
			//取得ファイルをZipに追加
			$zip->addFile(SYSTEM_PATH.$val, basename($val));
		}
		$zip->close();

		sleep(2);
		
		AWSMangos3Bucket::getInstance()->deleteLocalDirectory($temp);
		
		header("Location: /api/kyczipdl.php?f=".urlencode($apiPath.DIRECTORY_SEPARATOR.$downloadFilename));
		
		exit();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ口座番号の取得
	* @parameter	: なし
	* @return		: ユーザ口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 状態の表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoStatus() {
		echo $this -> dispListOption($this -> getStatusList(), $this -> account_status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoAccountType() {
		echo $this -> dispListOption($this -> getAccountTypeList(), $this -> accountType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	public function echoSatusSFrom() {
		echo $this -> sStatusFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoStatusSTo() {
		echo $this -> sStatusTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの表示
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function echoMail() {
		echo $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの表示
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function echoAgentCode() {
		echo $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: 結果セット
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: 結果セット
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getAccountNumber() {
		return $this -> accountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: 結果セット
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getKYCComments() {
		return $this -> comments;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開設日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_OPEN_FLG
											, PARAM_OPEN_FLG
											, VAL_INT_1
											, NO_STRING, $this -> openFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispLoginFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_LOGIN_FLG
										, PARAM_LOGIN_FLG
										, VAL_INT_1
										, NO_STRING, $this -> loginFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送信用パラメータの取得
	* @parameter	: なし
	* @return		: 送信用パラメータ
	-------------------------------------------------------------------------*/
	function getSendParams() {

		// 変数宣言部
		$rtn		= array();
		$account	= null;
		$row		= null;

		// データの取得
		$account	= $this -> getAccountCommon($this -> userAccount);
		$row		= $this -> getRowData($account);

		$rtn[] = $this -> userAccount;
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金用ステータスの修正パラメータ
	 * @parameter	: なし
	 * @return		: フラグ群
	 -------------------------------------------------------------------------*/
	function getDepostFlgs() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = VAL_INT_1;	// 第一フラグ
		$rtn[] = VAL_INT_1;	// 第二フラグ
		$rtn[] = VAL_INT_1;	// 第三フラグ
		$rtn[] = VAL_INT_1;	// 第四フラグ
		$rtn[] = VAL_INT_1; // 第五フラグ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エクスポートデータの作成
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function makeExportData() {
		// 変数宣言部
		$data				= NO_STRING;
		$arr				= null;

		// まずはタイトル
		header("Content-Type: text/html; charset=UTF-8");

		// anton

		$data = ($this -> lang == "en" ? 'Country,E-mail Address,Name,Account Number,Account Type,Upload Date,Status,Review Status,Update Timestamp,KYC Inspection Info'."\n" :
				'国,メールアドレス,氏名,口座番号,口座種別,アップロード日時,ステータス,審査状況,更新日時,KYC審査情報'."\n");

		// データの存在確認
		if($this -> isLoopData($this -> rs)) {

			foreach($this -> rs as $row) {

				// 配列の初期化
				$arr = array();

				// データの設定
				$arr[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_COUNTRY));
				$arr[] = $this -> getColumnData($row, COLUMN_USER_NAME);
				$arr[] = $this -> getNameCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT));
				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
				$arr[] = $this -> dispUserAccountTypeCommon($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE));
				$arr[] = $this -> getColumnData($row, COLUMN_MAX_CREATE_TIME);
				$arr[] = $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_USER_STATUS));
				$arr[] = $this -> arrValidate[$this -> getColumnData($row, COLUMN_VALIDATE_STATUS)];
				$arr[] = $this -> getColumnData($row, COLUMN_PROCESS_TIME);
				$arr[] = $this -> getColumnData($row, COLUMN_COMMENT);

				$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
			}
		}

		// 共通項目へデータをセット
		$this -> setExportDataCommon($data);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: getActivity
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getActivity() {

		$type 			= $this -> getType();
		$rs 			= array();
		$detail 		= array();
		$where 			= NO_STRING;
		$status 		= $this -> updateStatus;

		if($type == TYPE_UPDATE_ALL){
			if(!empty($this -> arrSelectAll)){
				$persons 	= $this -> arrSelectAll;

				$where .= '  (';
				foreach($this -> arrSelectAll as $row) {
					$statuses[] = ' user_account = (\')' . $row . '(\')';
				}
				
				$where .= implode(DELIMIT_OR, $statuses) . ')';
				
				$rs = $this -> accessSelect('SELECT_KYC_DETAILS', array($where));

				for($i = 0; $i < (count($persons)); $i++){

					 $detail[] = $persons[$i] . ' from [' . $this -> arrValidate[$this -> getColumnData($rs[$i], COLUMN_KYC_STATUS)] . '] to [' . $this -> arrValidate[$status] . ']';

				}

				$details = implode(DELIMIT_COMMA.'<br>', $detail);
				$message = 'Edited Review Status of '.$details;
			}else{
				$message = 'Saved without any changes';
			}

		}elseif($type == TYPE_SAVE_DETAIL){

			$rs = $this -> accessSelect('SELECT_KYC_DETAILS', array('user_account = '.$this -> userAccount));
			$newStatus 		= $this -> updateStatus;
			$newComment	 	= $this -> KYC_Comment;
			$origStatus		= $this -> getColumnData($rs[NO_COUNT], COLUMN_KYC_STATUS);
			$origComment 	= $this -> getColumnData($rs[NO_COUNT], 'kyc_comment');
		
			if($origStatus != $newStatus){
				$detail[] = 'KYC Status from ['.$this -> arrValidate[$origStatus].'] to ['.$this -> arrValidate[$newStatus].']';
			}

			if($origComment != $newComment){
				$detail[] = 'KYC Checking History';
			}

			if(!empty($detail)){
	
				$details = implode(DELIMIT_COMMA.'<br>', $detail);
				$message = 'Edited '.$this -> userAccount.'\'s '.$details;
	
			}else{
				$message = 'Saved without any changes';
			}
			
		}else if($type == TYPE_SAVE_IMAGE){
			$kId    = array();
			$arr 	= array();
			$rs 	= $this -> accessSelect('SELECT_USER_KYC', array($this -> userAccount));
			$kycIds = $this -> getDataPost(PARAM_STATUS);

			foreach ($kycIds as $kycId) {

				$arr 		= explode(DELIMIT_UNDER_BAR, $kycId);
				$newStat[] 	= $arr[0].'_'.$arr[1];

			}

			foreach ($rs as $rows) {

				$origStat[] = $this -> getColumnData($rows, COLUMN_K_ID).'_'.$this -> getColumnData($rows, COLUMN_STATUS);

			}

			sort($newStat);
			sort($origStat);

			for($i = 0; $i < (count($origStat)); $i++){
				
				if($origStat[$i] != $newStat[$i]){

					$newStatus  = explode(DELIMIT_UNDER_BAR, $newStat[$i]);
					$oldStat  	= explode(DELIMIT_UNDER_BAR, $origStat[$i]);
					$fileName 	= $this -> accessSelect('SELECT_KYC_NAME_BY_KID', array($oldStat[NO_COUNT]));

					$detail[] 	= ' KYC file status of '.$this -> getColumnData($fileName[NO_COUNT], COLUMN_OLD_FILENAME).' from ['.$this -> dispStatusName($oldStat[VAL_INT_1]).'] to ['.$this -> dispStatusName($newStatus[VAL_INT_1]).']';

				}
			}

			if(!empty($detail)){
	
				$details = implode(DELIMIT_COMMA.'<br>', $detail);
				$message = 'Edited '.$this -> userAccount.'\'s '.$details;
	
			}else{
				$message = 'Saved without any changes';
			}

		}elseif($type == TYPE_DELETE_IMAGE){

			$kycIds = $this -> getDataPost(PARAM_STATUS);
			$kycIds = $this -> getDataPost(PARAM_STATUS);
			$rs 	= $this -> accessSelect('SELECT_USER_KYC', array($this -> userAccount));

			foreach ($kycIds as $kycId) {
				$arr 		= explode(DELIMIT_UNDER_BAR, $kycId);
				$statuses[] 	= $arr[0].'_'.$arr[1];
			}

			for($i = 0; $i < (count($rs)); $i++){

				$kId  = explode(DELIMIT_UNDER_BAR, $statuses[$i]);

				if($kId[VAL_INT_1] == VAL_INT_2){
					$fileName 	= $this -> accessSelect('SELECT_KYC_NAME_BY_KID', array($kId[NO_COUNT]));
					$detail[] = 'KYC file '.$this -> getColumnData($fileName[NO_COUNT], COLUMN_OLD_FILENAME);
				}
				
	
			}

			if(!empty($detail)){
	
				$details = implode(DELIMIT_COMMA.'<br>', $detail);
				$message = 'Deleted '.$this -> userAccount.'\'s '.$details;
	
			}else{
				$message = 'Deleted nothing';
			}
		}elseif ($type == TYPE_VERTIFY) {
			$row 					= $this -> getAccountCommon($this -> userAccount);
			$fName 			= $this -> getColumnData($row[0], COLUMN_LAST_NAME);
			$lName 			= $this -> getColumnData($row[0], COLUMN_FIRST_NAME);
			$message 		= 'Verified '.$this -> userAccount.'\'s '.$lName.' '.$fName.' account status';
		}

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 22;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: dispStatusName
	 * @parameter	: kId
	 * @return		: 
	 -------------------------------------------------------------------------*/
	function dispStatusName($kId){

		$rtn = NO_STRING;

		switch ($kId) {
			case 0:
				$rtn = VAL_STR_UNAUTHENTICATED;
				break;

			case 1:
				$rtn = VAL_STR_AUTHENTICATED;
				break;

			case 2:
				$rtn = VAL_STR_DENIAL;
				break;

			case 3:
				$rtn = VAL_STR_PROCESSING;
				break;

			case 4:
				$rtn = VAL_STR_LACK_OF_DOCUMENTS;
				break;
			
			default:
				# code...
				break;
		}

	return $rtn;

	}

}
 ?>
