
<?php
require_once('config.php');

class APIGetRequestDetail extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $rId			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;
		$row		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> rId			= intval($this -> getDataPost(PARAM_R_ID));

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'R' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// データの取得
			$row = $this -> getRowData($this -> accessSelect('LIST_REQUEST_BY_R_ID', array($this -> rId)));

			// データ返却用に詰め替える
			$rtn[COLUMN_R_ID] = $this -> getColumnData($row, COLUMN_R_ID);

			$rtn[COLUMN_FROM_ACCOUNT]		= $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
			$rtn[COLUMN_TO_ACCOUNT]			= $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
			$rtn[COLUMN_CURRENCY]			= $this -> getColumnData($row, COLUMN_CURRENCY);
			$rtn[COLUMN_AMOUNT]				= $this -> getColumnData($row, COLUMN_AMOUNT);
			$rtn[COLUMN_MESSAGE]			= $this -> getColumnData($row, COLUMN_MESSAGE);
			$rtn[COLUMN_STATUS]				= $this -> getColumnData($row, COLUMN_STATUS);
			$rtn[COLUMN_CREATE_TIME]		= $this -> getColumnData($row, COLUMN_CREATE_TIME);
			$rtn[COLUMN_UPDATE_TIME]		= $this -> getColumnData($row, COLUMN_UPDATE_TIME);
			$rtn[COLUMN_SEND_MESSAGE]		= $this -> getColumnData($row, COLUMN_SEND_MESSAGE);
			$rtn[COLUMN_FROM_FEE]			= $this -> getColumnData($row, COLUMN_FROM_FEE);
			$rtn[COLUMN_TO_FEE]				= $this -> getColumnData($row, COLUMN_TO_FEE);
			$rtn[COLUMN_MAIL]				= $this -> getColumnData($row, COLUMN_MAIL);
			$rtn[COLUMN_FROM_LAST_NAME]		= $this -> getColumnData($row, COLUMN_LAST_NAME);
			$rtn[COLUMN_FROM_FIRST_NAME]	= $this -> getColumnData($row, COLUMN_FROM_FIRST_NAME);

			echo json_encode(array('result'			=> 'OK'
									, 'messages'	=> 'I_COMPLETE_PROCESS'
									, 'data'		=> $rtn));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 口座の存在確認
		$this -> user = $this -> getAccountCommon($this -> account);

		if(count($this -> user) == NO_COUNT) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 必須項目のチェック
		if(!$this -> checkNull($this -> rId)) {
			throw new Exception('E_REQUIRED_VALUE');
		}
	}
}

$api = new APIGetRequestDetail();
$api -> action();
?>