<?php
require_once(SYSTEM_LOGICS . 'admin_user/model.php');

class LogicAdminUser extends AdminUserModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {
		try {
			$saveResult				= true;

			// 初期データ処理
			$this -> init();
			
			if($this -> getType() == TYPE_ADMIN_USER_IMPORT) {
				$saveResult = $this -> saveUserAdminCSV();

				//check if save has failed
				if(!$saveResult) {
					//remove previous error message due to validation
					$_SESSION[MSG_ARRAY] = array();

					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_ADMIN_FAILED', array());
					$this -> setType(TYPE_ADMIN_IMPORT_FAIL_LIST);
				}
				$this -> lists();
			} elseif($this -> getType() == TYPE_ADMIN_USER_IMPORT_CONFIRM) {
				$this -> uploadCSV();
			} elseif($this -> getType() == TYPE_ADMIN_USER_CREATE) {
				$this -> insertActivity();
				$this -> saveUserAdmin();
				$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
				$this -> lists();
				$this -> setType(TYPE_ADMIN_USER_LIST);
			} elseif($this -> getType() == TYPE_ADMIN_USER_INPUT) {
				$this -> selectDepartmentList();
			} elseif($this -> getType() == TYPE_ADMIN_USER_DETAILS || $this -> getType() == TYPE_ADMIN_USER_EDIT_INPUT) {
				$this -> select();
				if($this -> getType() == TYPE_ADMIN_USER_EDIT_INPUT) {
					$this -> selectDepartmentList();
				}
			} elseif($this -> getType() == TYPE_ADMIN_USER_EDIT_SAVE) {
				$this -> insertActivity();
				$this -> updateUserAdmin();
				$this -> popUpSessionMessage(INFO, 'I_EDIT_SUCCESSFUL', array());
				$this -> select();
				$this -> setType(TYPE_ADMIN_USER_DETAILS);
			} elseif($this -> getType() == TYPE_ADMIN_USER_DELETE) {
				$this -> insertActivity();
				$this -> deleteAdminUser();
				$this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
				$this -> lists();
			} else {
			    $this -> lists();
			}
			

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ一覧の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		//set variables
		$where	= null;

		// データの取得
		$where	= $this -> getWhere();
		
		//echo "<pre>";
		//echo ($this -> setElementParam('LIST_ADMIN_USER', $where));
		
		$totalFetch = $this -> getRowData($this -> accessSelect("COUNT_ADMIN_USER", $where));
		
		$this -> setTotal($this -> getColumnData($totalFetch, 'admin_ctr'));
		
		$this -> setResult($this -> accessSelect('LIST_ADMIN_USER', $where));
		$this -> selectDepartmentList();
	}

	/*-------------------------------------------------------------------------
	* @function_name: select
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function select() {
		//set variables
		$userAccount	= $this -> getUserAccount();

		//get user details
		$this -> setResult($this -> accessSelect('SELECT_ADMIN_USER', array($userAccount)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: selectDepartmentList
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function selectDepartmentList() {
		//get user details
		$this -> setDepartmentList($this -> accessSelect('LIST_DEPT', array()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: updateUserAdmin
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function updateUserAdmin() {
		//get edit details
		$userAdminEditData 	= $this ->  getUserEditData();

		$loginData			= array();
		$userData 			= array();
		$userAccessData 	= array();

		//set login data
		$loginData[]		= $userAdminEditData['u_id']; 															//u_id
		$loginData[]		= $userAdminEditData['user_name']; 														//user name (email)
		$loginData[]		= password_hash($userAdminEditData['password'].VAL_STR_AUTH_HASH_SECRET_KEY, PASSWORD_BCRYPT, array('cost'=>13)); 	//password

		//set user data
		$userData[]			= $userAdminEditData['user_account'];					//user account
		$userData[]			= $userAdminEditData['last_name'];						//last name
		$userData[]			= $userAdminEditData['first_name'];						//first name
		$userData[]			= $userAdminEditData['user_name'];						//mail

		//set user access data
		$userAccessData[]	= $userAdminEditData['user_account'];					//user account
		$userAccessData[]	= $userAdminEditData['department'];						//department
		$userAccessData[]	= $userAdminEditData['password'];						//password
		$userAccessData[]	= $userAdminEditData['function_access'];				//function access

		$this -> accessModify('UPDATE_LOGIN', $loginData);
		$this -> accessModify('UPDATE_ADMIN_USER', $userData);
		$this -> accessModify('UPDATE_ADMIN_ACCESS', $userAccessData);
	}

	/*-------------------------------------------------------------------------
	* @function_name: deleteAdminUser
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function deleteAdminUser() {
		//set variables
		$userAccount	= $this -> getUserAccount();

		//get user details
		$this -> setResult($this -> accessModify('DELETE_ADMIN_USER', array($userAccount)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: saveUserAdmin
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function saveUserAdmin() {
		$loginData			= array();
		$userData 			= $this -> getUserAdminData();
		$userAccessData 	= $this -> getUserAccessData();
		$password 			= $this -> generatePassword();

		//login details
		$loginData[]		= $userData[0];	//uid
		$loginData[]		= $userData[1]; //email
		$loginData[]		= password_hash($password.VAL_STR_AUTH_HASH_SECRET_KEY, PASSWORD_BCRYPT, array('cost'=>13)); //password

		//add password field to access data
		$userAccessData[] 	= $password;

		$this -> accessModify('INSERT_LOGIN', $loginData);
		$this -> accessModify('INSERT_ADMIN_USER', $userData);
		$this -> accessModify('INSERT_ADMIN_ACCESS', $userAccessData);
	}

	/*-------------------------------------------------------------------------
	* @function_name: saveUserAdminCSV
	* @parameter	:
	* @return		: boolean - true if all are imported successfuly false if there are failed imports
	-------------------------------------------------------------------------*/
	function saveUserAdminCSV() {
		$adminUsersArray			= array();
		$failArray					= array();
		$rtn 						= true;

		//put csv file int array
		$adminUsersArray = json_decode($this -> getImportData(), true);

		//parse array
		foreach ($adminUsersArray as $adminUser) {
			//set object attributes
			$this -> setParameterCSV($adminUser);

			//validate parameters
			if($this -> validateAdminFields()) {
				//save admin user
				$this -> saveUserAdmin();
			} else {
				$failArray[] = $adminUser;
			}
		}

		//if fail array is not empty
		if(count($failArray) > 0) {
			$this -> setFailList($failArray);
			$this -> setFailID();
			$this -> writeFailToCSV($failArray);
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: uploadCSV
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function uploadCSV() {
		$adminUsersArray			= array();
		$dataArray					= array();

		//put csv file int array
		$adminUsersArray = $this -> parseCSV();

		//parse array
		foreach ($adminUsersArray as $adminUser) {
			//put into dataArray
			$dataArray[] = $adminUser;
		}

		//check if success array has record
		if(count($dataArray) > 0) {
			$this -> setAdminUserDataJSON($dataArray);
		}
	}

	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}
}
?>